/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8229.DeviceView;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.jdm8229.DeviceView.ChassisIntegrated;
import ibm.nways.jdm8229.DeviceView.ChassisLike;
import ibm.nways.jdm8229.DeviceView.ChassisUnknown;
import ibm.nways.jdm8229.DeviceView.LeafCompositeLike;
import ibm.nways.ras.RAS;
import ibm.nways.widgets.WidgetCookie;
import java.awt.Component;
import java.awt.Point;
import java.io.Serializable;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class Chassis
implements ChassisLike {
    private final Vector components = new Vector();
    private Vector interfaceModels;
    protected GenModel interfaceGenModel;
    private Vector macBrPortModels;
    protected GenModel macBrPortGenModel;
    private String cookieId;
    protected JdmBrowser jdmBrowser;
    protected GraphicContainer graphicContainer = new GraphicContainer();
    protected GraphicContainer container = new GraphicContainer();
    public static String PROPERTIES_FILE = "properties/Jdm8229.txt";

    protected Chassis(String string) {
        this.setCookieId(string);
    }

    protected void setCookieId(String string) {
        this.cookieId = string;
    }

    protected String getCookieId() {
        return this.cookieId;
    }

    public void discoverChildren() {
    }

    public void add(LeafCompositeLike leafCompositeLike) {
        this.components.addElement(leafCompositeLike);
    }

    public void setCommonInformation(JdmBrowser jdmBrowser) {
        this.jdmBrowser = jdmBrowser;
        try {
            GenModel genModel = (GenModel)this.jdmBrowser.getModel();
            GenModel genModel2 = (GenModel)genModel.getComponent("ConfigurationFolder");
            genModel = (GenModel)genModel2.getComponent("Communications");
            genModel = (GenModel)genModel.getComponent("Media");
            genModel = (GenModel)genModel.getComponent("Mib2");
            this.interfaceGenModel = genModel = (GenModel)genModel.getComponent("Interface");
            this.interfaceModels = genModel.getRestOfInfo("Panel", "default", null, null);
            genModel = (GenModel)genModel2.getComponent("SystemFolder");
            genModel = (GenModel)genModel.getComponent("Device");
            this.macBrPortGenModel = genModel = (GenModel)genModel.getComponent("MacBrPort");
            this.macBrPortModels = genModel.getRestOfInfo("Panel", "default", null, null);
            return;
        }
        catch (RemoteException remoteException) {
            RAS.logException(19, 3, this, "setCommonInformation", (Exception)remoteException);
            return;
        }
    }

    public void draw() {
        int n = 20;
        GenModel genModel = null;
        try {
            GenModel genModel2 = (GenModel)this.jdmBrowser.getModel();
            genModel2 = (GenModel)genModel2.getComponent("ConfigurationFolder");
            genModel2 = (GenModel)genModel2.getComponent("SystemFolder");
            genModel = (GenModel)genModel2.getComponent("System");
        }
        catch (Exception exception) {
            RAS.logException(19, 3, this, "draw", exception);
        }
        long l = System.currentTimeMillis();
        WidgetCookie widgetCookie = new WidgetCookie(this.cookieId, "ibm.nways.jdm8229.Resources", null, "ibm.nways.jdm8229.WCDefault", genModel, this.jdmBrowser, n, "ibm.nways.mib2.eui.SystemPanel");
        this.graphicContainer.add((GraphicContainer)widgetCookie);
        GraphicImage graphicImage = widgetCookie.GetImage();
        GraphicFlyOver graphicFlyOver = graphicImage.getFlyOver();
        graphicFlyOver.setText(String.valueOf(graphicFlyOver.getText()) + "-" + this.getIp());
        graphicImage.setFlyOver(graphicFlyOver);
        GraphicHelp graphicHelp = new GraphicHelp((BrowserApplet)this.jdmBrowser, new Point(0, 0), new HelpRef("ibm.nways.jdm8229", "ibm.nways.jdm8229.BoxGraphic.html"));
        this.container.add((GraphicComponent)graphicHelp);
        this.graphicContainer.setLocation(20, 20);
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            LeafCompositeLike leafCompositeLike = (LeafCompositeLike)enumeration.nextElement();
            try {
                leafCompositeLike.draw();
            }
            catch (Exception exception) {
                RAS.logInformation(19, 3, this, "draw", "Exception drawing object -> " + leafCompositeLike.getClass().getName());
                RAS.logException(19, 3, this, "draw", exception);
            }
        }
        long l2 = System.currentTimeMillis();
        if (RAS.isEnabled(19, 3)) {
            RAS.trace(19, 3, this, "draw", "Time to draw component of Chassis -> " + (l2 - l));
        }
        this.container.add(this.graphicContainer);
        this.container.doLayout();
    }

    public GraphicPanel getGraphicPanel() {
        Serializable serializable;
        if (this instanceof ChassisUnknown) {
            return null;
        }
        JdmLayout jdmLayout = (JdmLayout)this.jdmBrowser.getLayout();
        String string = "8229.layout.scheme";
        String string2 = "8229.layout.fractions";
        Properties properties = null;
        if (this instanceof ChassisIntegrated) {
            string = "8229i.layout.scheme";
            string2 = "8229i.layout.fractions";
        }
        try {
            serializable = new URL(this.jdmBrowser.getDocumentBase(), PROPERTIES_FILE);
            properties = new Properties();
            properties.load(((URL)serializable).openStream());
        }
        catch (Exception exception) {
            RAS.logException(19, 3, this, "getGraphicPanel", exception);
        }
        if (properties != null) {
            serializable = new Integer((String)((Hashtable)properties).get(string));
            jdmLayout.setScheme(((Integer)serializable).intValue());
            String string3 = (String)((Hashtable)properties).get(string2);
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            float[] fArray = new float[stringTokenizer.countTokens()];
            boolean bl = true;
            int n = 0;
            while (n < fArray.length && stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                try {
                    fArray[n] = Float.valueOf(string4).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    if (RAS.isEnabled(19, 3)) {
                        RAS.trace(19, 3, this, "getGraphicPanel", "Bad layout.fractions parameter -> " + numberFormatException.getMessage());
                    }
                    bl = false;
                }
                ++n;
            }
            if (bl) {
                jdmLayout.setFracts(fArray);
            }
        }
        return new GraphicPanel((GraphicHandler)this.jdmBrowser, (Component)this.container);
    }

    public String getIp() {
        String string = "";
        try {
            SnmpContextModel snmpContextModel = (SnmpContextModel)((GenModel)this.jdmBrowser.getModel()).getComponent("_ContextInfo");
            ModelInfo modelInfo = snmpContextModel.getConfig();
            string = (String)((Object)modelInfo.get("Config.Address"));
        }
        catch (Exception exception) {
            RAS.logException(19, 3, this, "getIp", exception);
        }
        return string;
    }

    protected ModelInfo getIfModelInfo(int n) {
        Enumeration enumeration = this.interfaceModels.elements();
        while (enumeration.hasMoreElements()) {
            ModelInfo modelInfo = (ModelInfo)enumeration.nextElement();
            if ((Integer)modelInfo.get("Index.IfIndex") != n) continue;
            return modelInfo;
        }
        return null;
    }

    protected int getIfType(int n) {
        ModelInfo modelInfo = this.getIfModelInfo(n);
        if (modelInfo == null) {
            return -1;
        }
        return (Integer)modelInfo.get("Panel.IfType");
    }

    protected String getMacAddress(int n) {
        Enumeration enumeration = this.macBrPortModels.elements();
        while (enumeration.hasMoreElements()) {
            ModelInfo modelInfo = (ModelInfo)enumeration.nextElement();
            if ((Integer)modelInfo.get("Index.MacBrPortIndex") != n) continue;
            return ((OctetString)modelInfo.get("Panel.MacBrPortUniversalAddr")).toString().toUpperCase();
        }
        return null;
    }

    protected String getUserMacAddress(int n) {
        Enumeration enumeration = this.macBrPortModels.elements();
        while (enumeration.hasMoreElements()) {
            ModelInfo modelInfo = (ModelInfo)enumeration.nextElement();
            if ((Integer)modelInfo.get("Index.MacBrPortIndex") != n) continue;
            String string = ((OctetString)modelInfo.get("Panel.MacBrPortAddr")).toString().toUpperCase();
            if (string.equals("000000000000")) {
                string = ((OctetString)modelInfo.get("Panel.MacBrPortUniversalAddr")).toString().toUpperCase();
            }
            return string;
        }
        return null;
    }
}

